/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.util.useradmin;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSecurityList;
import filenet.vw.api.VWSession;

public class UserUtilities {
    static boolean isAdministrator(VWSession vws) {
        boolean IsAnAdministrator = false;
        int HasGroups = 0;
        try {
            VWSecurityList GroupList = vws.fetchUserGroups(100);
            while (GroupList.hasNext()) {
                Object tempGroup = GroupList.next();
                System.out.println(tempGroup.toString());
                if (tempGroup.equals("PWConfiguration")) {
                    ++HasGroups;
                }
                if (!tempGroup.equals("PWAdministration")) continue;
                HasGroups += 2;
            }
            System.out.println("HasGroups = " + HasGroups);
            switch (HasGroups) {
                case 0: {
                    IsAnAdministrator = vws.isMemberOfGroup("SysAdminG");
                    break;
                }
                case 1: {
                    IsAnAdministrator = vws.isMemberOfGroup("SysAdminG") || vws.isMemberOfGroup("PWConfiguration");
                    break;
                }
                case 2: {
                    IsAnAdministrator = vws.isMemberOfGroup("SysAdminG") || vws.isMemberOfGroup("PWAdministration");
                    break;
                }
                case 3: {
                    IsAnAdministrator = vws.isMemberOfGroup("SysAdminG") || vws.isMemberOfGroup("PWConfiguration") || vws.isMemberOfGroup("PWAdministration");
                }
            }
        }
        catch (VWException vwe) {
            System.out.println(vwe.getMessage());
        }
        return IsAnAdministrator;
    }

    static int getSecurityListSize(VWSecurityList vws) {
        int UserCount = 0;
        try {
            vws.resetFetch();
            while (vws.hasNext()) {
                ++UserCount;
                vws.next();
            }
            vws.resetFetch();
        }
        catch (VWException vwe) {
            System.out.println(vwe.getMessage());
        }
        return UserCount;
    }

    static String[] getSecurityListNames(VWSecurityList vws) {
        int UserCount = UserUtilities.getSecurityListSize(vws) > 1 ? UserUtilities.getSecurityListSize(vws) : 1;
        String[] UserNames = new String[UserCount];
        try {
            for (int i = 0; i < UserCount; ++i) {
                UserNames[i] = vws.next().toString();
            }
        }
        catch (VWException vwe) {
            System.out.println(vwe.getMessage());
        }
        return UserNames;
    }
}

